﻿using System;
using System.Collections.Generic;
using System.Linq;
using BMS.VistaIntegration.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Data;
using DC = BMS.DataContracts;
using InfoWorld.HL7.ITS;
using BMS.ServicesWrapper.EVS;
using BMS.Utils;
using FC = BMS.Facade.Data;
using InfoWorld.EVS.CTSMAPI;
using BMS.ServicesWrapper.BMService;
using BMS.VistaWorker2.Writer;

namespace Import_VistaJob
{
    public class ADTQuery
    {
        static VistASite vistaSite;
        static IList<CDWithProperties> orderableItems = null;
        static IList<CD> genderList = EVSFactory.InstanceWindows.GetCodes(new CodeFilterParameters() { MaxSelectedCodes = int.MaxValue, VocabularyDomain = FC.Util.Vocabulary.Gender.ToString() });
        static List<CD> typeOfMovementList = EVSFactory.InstanceWindows.GetCodes(new CodeFilterParameters() { MaxSelectedCodes = int.MaxValue, VocabularyDomain = FC.Util.Vocabulary.TypeOfMovement.ToString() }).ToList();
        static List<CD> medicalDivisionList = EVSFactory.InstanceWindows.GetCodes(new CodeFilterParameters() { MaxSelectedCodes = int.MaxValue, VocabularyDomain = FC.Util.Vocabulary.VistaMedicalCenterDivision.ToString() }).ToList();
        static List<CD> specialtyList = EVSFactory.InstanceWindows.GetCodes(new CodeFilterParameters() { MaxSelectedCodes = int.MaxValue, VocabularyDomain = FC.Util.Vocabulary.VistaTreatingSpecialty.ToString() }).ToList();
        static List<FC.HospitalLocation> hospitalLocations = new List<FC.HospitalLocation>();

        public ADTQuery(VistASite _vistaSite, IList<CDWithProperties> _orderableItems)
        {
            vistaSite = _vistaSite;
            orderableItems = _orderableItems;
            hospitalLocations = Utils.GetHospitalLocationsByVista(vistaSite.Id);
        }

        public void InsertAdmissionOrder(OrderAction obj, DC.VistaIntegrationLog vistaIntegrationLog)
        {            
           
            int retry = 0;
            while (retry < 3)
            {
                //SqlConnection connection = new SqlConnection(ConfigurationManager.ConnectionStrings["BMSDBConnString"].ConnectionString);
                SqlCommand cmd = new SqlCommand("usp_Insert_Admission_Request", GlobalConnections.BmsConnection);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.CommandTimeout = GlobalConnections.BmsConnection.ConnectionTimeout;
                try
                {
                    if (obj.Order == null)
                    {
                        Tracer.TraceMessage("Order is null for ien: " + obj.OrderId);
                        return;
                    }
                    II patientId = GetPatientId(obj.Order.Patient);
                    if (patientId == null) return;
                    II signedById = GetPersonId(obj.SignedBy);
                    II providerId = GetPersonId(obj.Provider);
                    FC.HospitalLocation hospitalLocation = GetHospitalLocation(obj.Order.HospitalLocationId);
                    string wardId = hospitalLocation != null ? hospitalLocation.WardLocationId : null;

                    SqlParameter idParam = cmd.Parameters.Add("@ID", SqlDbType.Int);
                    idParam.Direction = ParameterDirection.Output;
                    cmd.Parameters.Add("@DOMAIN_ID", SqlDbType.VarChar, 50).Value = Utils.DomainId;
                    cmd.Parameters.Add("@ORDERED_DATE", SqlDbType.DateTime).Value = obj.DateTimeOrdered;
                    cmd.Parameters.Add("@PATIENT_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(patientId.extension);
                    cmd.Parameters.Add("@IEN", SqlDbType.VarChar, 50).Value = obj.OrderId;
                    if (obj.DateTimeSigned.HasValue)
                        cmd.Parameters.Add("@SIGNED_DATE", SqlDbType.DateTime).Value = obj.DateTimeSigned.Value;
                    else
                        cmd.Parameters.Add("@SIGNED_DATE", SqlDbType.DateTime).Value = DBNull.Value;
                    if (obj.ReleaseDateTime.HasValue)
                        cmd.Parameters.Add("@RELEASED_DATE", SqlDbType.DateTime).Value = obj.ReleaseDateTime.Value;
                    else
                        cmd.Parameters.Add("@RELEASED_DATE", SqlDbType.DateTime).Value = DBNull.Value;
                    if (providerId != null)
                        cmd.Parameters.Add("@PROVIDER_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(providerId.extension);
                    else
                        cmd.Parameters.Add("@PROVIDER_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;
                    if (signedById != null)
                        cmd.Parameters.Add("@SIGNED_BY_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(signedById.extension);
                    else
                        cmd.Parameters.Add("@SIGNED_BY_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;
                    cmd.Parameters.Add("@VISTA_SITE_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(vistaSite.Id);
                    if (hospitalLocation != null)
                        cmd.Parameters.Add("@HOSPITAL_LOCATION_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(hospitalLocation.Id.extension);
                    else
                        cmd.Parameters.Add("@HOSPITAL_LOCATION_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;
                    if (!string.IsNullOrEmpty(obj.OrderText))
                        cmd.Parameters.Add("@ORDER_TEXT", SqlDbType.VarChar).Value = obj.OrderText;
                    else
                        cmd.Parameters.Add("@ORDER_TEXT", SqlDbType.VarChar).Value = DBNull.Value;
                    if (!string.IsNullOrEmpty(wardId) && !wardId.Equals(Guid.Empty.ToString()))
                        cmd.Parameters.Add("@WARD_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(wardId);
                    else
                        cmd.Parameters.Add("@WARD_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;
                    cmd.Parameters.Add("@IS_ACTIVE", SqlDbType.Bit).Value = (obj.Order.StatusId != null && obj.Order.StatusId == "6") ? true : false;
                    cmd.Parameters.Add("@FACILITY_LIST", SqlDbType.NVarChar).Value = Utils.CreateOrderFacilitiesList(obj.Order.OrderOrderableItemIds, vistaSite, orderableItems);

                    cmd.ExecuteNonQuery();
                    Utils.SaveVistaIntegrationLog(vistaIntegrationLog.Ien, vistaSite.Name, vistaIntegrationLog.File);
                    retry = 3;
                }
                catch (SqlException ex)
                {
                    if (ex.Number == 1209) //Deadlock
                    {
                        if (retry == 2)
                        {
                            Tracer.TraceException(ex);
                            throw ex;
                        }
                        else
                        {
                            retry++;
                            GlobalConnections.BmsConnection.Close();
                        }
                    }
                    else
                    {
                        retry = 3;
                        Tracer.TraceException(ex);
                        throw ex;

                    }
                }
                catch (Exception ex)
                {
                    retry = 3;
                    Tracer.TraceException(ex);
                    throw ex;
                }
            }
        }

        public void InsertTransferOrder(OrderAction obj, DC.VistaIntegrationLog vistaIntegrationLog)
        {
            int retry = 3;
            while (retry < 3)
            {
            SqlCommand cmd = new SqlCommand("usp_Insert_Movement_Request", GlobalConnections.BmsConnection);
            cmd.CommandType = CommandType.StoredProcedure;
            cmd.CommandTimeout = GlobalConnections.BmsConnection.ConnectionTimeout;
            try
            {
                if (obj.Order == null)
                {
                    Tracer.TraceMessage("Order is null for ien: " + obj.OrderId);
                    return;
                }
                II patientId = GetPatientId(obj.Order.Patient);
                if (patientId == null) return;
                II signedById = GetPersonId(obj.SignedBy);
                II providerId = GetPersonId(obj.Provider);                
                FC.HospitalLocation hospitalLocation = GetHospitalLocation(obj.Order.HospitalLocationId);
                string wardId = hospitalLocation != null ? hospitalLocation.WardLocationId : null;                

                SqlParameter idParam = cmd.Parameters.Add("@ID", SqlDbType.Int);
                idParam.Direction = ParameterDirection.Output;
                cmd.Parameters.Add("@DOMAIN_ID", SqlDbType.VarChar, 50).Value = Utils.DomainId;                
                cmd.Parameters.Add("@PATIENT_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(patientId.extension);
                cmd.Parameters.Add("@IEN", SqlDbType.VarChar, 50).Value = obj.OrderId;
                cmd.Parameters.Add("@ORDERED_DATE", SqlDbType.DateTime).Value = obj.DateTimeOrdered;
                cmd.Parameters.Add("@IS_ACTIVE", SqlDbType.Bit).Value = (obj.Order.StatusId != null && obj.Order.StatusId == "6") ? true : false;
                if (obj.ReleaseDateTime.HasValue)
                    cmd.Parameters.Add("@RELEASED_DATE", SqlDbType.DateTime).Value = obj.ReleaseDateTime.Value;
                else
                    cmd.Parameters.Add("@RELEASED_DATE", SqlDbType.DateTime).Value = DBNull.Value;
                if (obj.DateTimeSigned.HasValue)
                    cmd.Parameters.Add("@SIGNED_DATE", SqlDbType.DateTime).Value = obj.DateTimeSigned.Value;
                else
                    cmd.Parameters.Add("@SIGNED_DATE", SqlDbType.DateTime).Value = DBNull.Value;
                if (signedById != null)
                    cmd.Parameters.Add("@SIGNED_BY_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(signedById.extension);
                else
                    cmd.Parameters.Add("@SIGNED_BY_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;
                if (providerId != null)
                    cmd.Parameters.Add("@PROVIDER_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(providerId.extension);
                else
                    cmd.Parameters.Add("@PROVIDER_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;                
                cmd.Parameters.Add("@SCHEDULER_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;
                cmd.Parameters.Add("@VISTA_SITE_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(vistaSite.Id);
                if (hospitalLocation != null)
                    cmd.Parameters.Add("@HOSPITAL_LOCATION_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(hospitalLocation.Id.extension);
                else
                    cmd.Parameters.Add("@HOSPITAL_LOCATION_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;
                if (!string.IsNullOrEmpty(obj.OrderText))
                    cmd.Parameters.Add("@ORDER_TEXT", SqlDbType.VarChar).Value = obj.OrderText;
                else
                    cmd.Parameters.Add("@ORDER_TEXT", SqlDbType.VarChar).Value = DBNull.Value;
                if (!string.IsNullOrEmpty(wardId) && !wardId.Equals(Guid.Empty.ToString()))
                    cmd.Parameters.Add("@WARD_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(wardId);
                else
                    cmd.Parameters.Add("@WARD_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;                
                cmd.Parameters.Add("@FACILITY_LIST", SqlDbType.NVarChar).Value = Utils.CreateOrderFacilitiesList(obj.Order.OrderOrderableItemIds, vistaSite, orderableItems);

                cmd.ExecuteNonQuery();
                Utils.SaveVistaIntegrationLog(vistaIntegrationLog.Ien, vistaSite.Name, vistaIntegrationLog.File);
                retry = 3;
                }
                catch (SqlException ex)
                {
                    if (ex.Number == 1209) //Deadlock
                    {
                        if (retry == 2)
                        {
                            Tracer.TraceException(ex);
                            throw ex;
                        }
                        else
                        {
                            retry++;
                            GlobalConnections.BmsConnection.Close();
                        }
                    }
                    else
                    {
                        retry = 3;
                        Tracer.TraceException(ex);
                        throw ex;

                    }
                }
                catch (Exception ex)
                {
                    retry = 3;
                    Tracer.TraceException(ex);
                    throw ex;
                }
            }
            
        }

        public void InsertDischargeOrder(OrderAction obj, DC.VistaIntegrationLog vistaIntegrationLog)
        {

            int retry = 0;
            while (retry < 3)
            {
                SqlCommand cmd = new SqlCommand("usp_Insert_Discharge_Request", GlobalConnections.BmsConnection);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.CommandTimeout = GlobalConnections.BmsConnection.ConnectionTimeout;
                try
                {
                    if (obj.Order == null)
                    {
                        Tracer.TraceMessage("Order is null for ien: " + obj.OrderId);
                        return;
                    }
                    II patientId = GetPatientId(obj.Order.Patient);
                    if (patientId == null) return;
                    II signedById = GetPersonId(obj.SignedBy);
                    II providerId = GetPersonId(obj.Provider);
                    FC.HospitalLocation hospitalLocation = GetHospitalLocation(obj.Order.HospitalLocationId);
                    string wardId = hospitalLocation != null ? hospitalLocation.WardLocationId : null;
                    CD orderableItem = null;
                    if (obj.Order.OrderOrderableItemIds != null && obj.Order.OrderOrderableItemIds.Count > 0)
                        orderableItem = GetOrderableItem(obj.Order.OrderOrderableItemIds);

                    SqlParameter idParam = cmd.Parameters.Add("@ID", SqlDbType.Int);
                    idParam.Direction = ParameterDirection.Output;
                    cmd.Parameters.Add("@DOMAIN_ID", SqlDbType.VarChar, 50).Value = Utils.DomainId;
                    cmd.Parameters.Add("@IEN", SqlDbType.VarChar, 50).Value = obj.OrderId;
                    cmd.Parameters.Add("@PATIENT_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(patientId.extension);
                    cmd.Parameters.Add("@ORDERED_DATE", SqlDbType.DateTime).Value = obj.DateTimeOrdered;
                    cmd.Parameters.Add("@IS_ACTIVE", SqlDbType.Bit).Value = (obj.Order.StatusId != null && obj.Order.StatusId == "6") ? true : false;
                    if (obj.ReleaseDateTime.HasValue)
                        cmd.Parameters.Add("@RELEASED_DATE", SqlDbType.DateTime).Value = obj.ReleaseDateTime.Value;
                    else
                        cmd.Parameters.Add("@RELEASED_DATE", SqlDbType.DateTime).Value = DBNull.Value;
                    if (obj.DateTimeSigned.HasValue)
                        cmd.Parameters.Add("@SIGNED_DATE", SqlDbType.DateTime).Value = obj.DateTimeSigned.Value;
                    else
                        cmd.Parameters.Add("@SIGNED_DATE", SqlDbType.DateTime).Value = DBNull.Value;
                    if (signedById != null)
                        cmd.Parameters.Add("@SIGNED_BY_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(signedById.extension);
                    else
                        cmd.Parameters.Add("@SIGNED_BY_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;
                    if (providerId != null)
                        cmd.Parameters.Add("@PROVIDER_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(providerId.extension);
                    else
                        cmd.Parameters.Add("@PROVIDER_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;
                    cmd.Parameters.Add("@SCHEDULER_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;
                    cmd.Parameters.Add("@VISTA_SITE_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(vistaSite.Id);
                    if (hospitalLocation != null)
                        cmd.Parameters.Add("@HOSPITAL_LOCATION_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(hospitalLocation.Id.extension);
                    else
                        cmd.Parameters.Add("@HOSPITAL_LOCATION_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;
                    if (!string.IsNullOrEmpty(obj.OrderText))
                        cmd.Parameters.Add("@ORDER_TEXT", SqlDbType.VarChar).Value = obj.OrderText;
                    else
                        cmd.Parameters.Add("@ORDER_TEXT", SqlDbType.VarChar).Value = DBNull.Value;
                    if (orderableItem != null)
                    {
                        cmd.Parameters.Add("@ORDERABLE_ITEM_CODE", SqlDbType.VarChar, 100).Value = orderableItem.code;
                        cmd.Parameters.Add("@ORDERABLE_ITEM_CODE_SYSTEM", SqlDbType.VarChar, 100).Value = orderableItem.codeSystem;
                        cmd.Parameters.Add("@ORDERABLE_ITEM_CODE_SYSTEM_NAME", SqlDbType.VarChar, 100).Value = orderableItem.codeSystemName;
                        cmd.Parameters.Add("@ORDERABLE_ITEM_DISPLAY_NAME", SqlDbType.VarChar, 250).Value = orderableItem.displayName;
                    }
                    else
                    {
                        cmd.Parameters.Add("@ORDERABLE_ITEM_CODE", SqlDbType.VarChar, 100).Value = DBNull.Value;
                        cmd.Parameters.Add("@ORDERABLE_ITEM_CODE_SYSTEM", SqlDbType.VarChar, 100).Value = DBNull.Value;
                        cmd.Parameters.Add("@ORDERABLE_ITEM_CODE_SYSTEM_NAME", SqlDbType.VarChar, 100).Value = DBNull.Value;
                        cmd.Parameters.Add("@ORDERABLE_ITEM_DISPLAY_NAME", SqlDbType.VarChar, 250).Value = DBNull.Value;
                    }
                    if (!string.IsNullOrEmpty(wardId) && !wardId.Equals(Guid.Empty.ToString()))
                        cmd.Parameters.Add("@WARD_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(wardId);
                    else
                        cmd.Parameters.Add("@WARD_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;
                    string facilityList = Utils.CreateOrderFacilitiesList(obj.Order.OrderOrderableItemIds, vistaSite, orderableItems);
                    if (!string.IsNullOrEmpty(facilityList))
                        cmd.Parameters.Add("@FACILITY_LIST", SqlDbType.NVarChar).Value = facilityList;
                    else
                        cmd.Parameters.Add("@FACILITY_LIST", SqlDbType.NVarChar).Value = DBNull.Value;
                    cmd.ExecuteNonQuery();
                    Utils.SaveVistaIntegrationLog(vistaIntegrationLog.Ien, vistaSite.Name, vistaIntegrationLog.File);
                    retry = 3;
                }
                catch (SqlException ex)
                {
                    if (ex.Number == 1209) //Deadlock
                    {
                        if (retry == 2)
                        {
                            Tracer.TraceException(ex);
                            throw ex;
                        }
                        else
                        {
                            retry++;
                            GlobalConnections.BmsConnection.Close();
                        }
                    }
                    else
                    {
                        retry = 3;
                        Tracer.TraceException(ex);
                        throw ex;

                    }
                }
                catch (Exception ex)
                {
                    retry = 3;
                    Tracer.TraceException(ex);
                    throw ex;
                }
            }
           
        }

        public void InsertScheduledAdmission(ScheduledAdmission obj)
        {
            int retry = 0;
            while (retry < 3)
            {
            SqlCommand cmd = new SqlCommand("usp_Insert_Scheduled_Admission", GlobalConnections.BmsConnection);
            cmd.CommandType = CommandType.StoredProcedure;
            cmd.CommandTimeout = GlobalConnections.BmsConnection.ConnectionTimeout;
            try
            {
                II patientId = GetPatientId(obj.Patient);
                if (patientId == null) return;
                II schedulerId = GetPersonId(obj.Scheduler);
                II providerId = GetPersonId(obj.Provider);
                FC.Ward ward = Utils.GetWardByIen(obj.WardLocationId, vistaSite.Id);
                CD specialty = GetCDByIen(obj.TreatingSpecialtyId, FC.Util.Vocabulary.VistaTreatingSpecialty.ToString());
                CD medicalDivision = GetCDByIen(obj.MedicalCenterDivisionId, FC.Util.Vocabulary.VistaMedicalCenterDivision.ToString());

                cmd.Parameters.Add("@ID", SqlDbType.Int).Value = null;
                cmd.Parameters[0].Direction = ParameterDirection.Output;                
                cmd.Parameters.Add("@PATIENT_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(patientId.extension);                
                if (!string.IsNullOrEmpty(obj.IEN))
                    cmd.Parameters.Add("@IEN", SqlDbType.VarChar, 50).Value = obj.IEN;
                else
                    cmd.Parameters.Add("@IEN", SqlDbType.VarChar, 50).Value = DBNull.Value;
                cmd.Parameters.Add("@DOMAIN_ID", SqlDbType.VarChar, 50).Value = Utils.DomainId;
                if (obj.DateTimeCancelled.HasValue)
                    cmd.Parameters.Add("@CANCELED_DATE", SqlDbType.DateTime).Value = obj.DateTimeCancelled.Value;
                else
                    cmd.Parameters.Add("@CANCELED_DATE", SqlDbType.DateTime).Value = DBNull.Value;
                cmd.Parameters.Add("@RESERVATION_DATE", SqlDbType.DateTime).Value = obj.ReservationDateTime;                
                if (schedulerId != null)                                    
                    cmd.Parameters.Add("@SCHEDULER_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(schedulerId.extension);                
                else
                    cmd.Parameters.Add("@SCHEDULER_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;                
                if (providerId != null)
                    cmd.Parameters.Add("@PROVIDER_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(providerId.extension);                
                else
                    cmd.Parameters.Add("@PROVIDER_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;                                
                cmd.Parameters.Add("@VISTA_SITE_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(vistaSite.Id);
                if (ward != null)
                    cmd.Parameters.Add("@WARD_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(ward.Id.extension);                
                else
                    cmd.Parameters.Add("@WARD_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;               
                if (specialty != null)
                {
                    cmd.Parameters.Add("@SPECIALITY_CODE", SqlDbType.VarChar, 100).Value = specialty.code;
                    cmd.Parameters.Add("@SPECIALITY_CODE_SYSTEM", SqlDbType.VarChar, 100).Value = specialty.codeSystem;
                    cmd.Parameters.Add("@SPECIALITY_CODE_SYSTEM_NAME", SqlDbType.VarChar, 100).Value = specialty.codeSystemName;
                    cmd.Parameters.Add("@SPECIALITY_DISPLAY_NAME", SqlDbType.VarChar, 250).Value = specialty.displayName;
                }
                else
                {
                    cmd.Parameters.Add("@SPECIALITY_CODE", SqlDbType.VarChar, 100).Value = DBNull.Value;
                    cmd.Parameters.Add("@SPECIALITY_CODE_SYSTEM", SqlDbType.VarChar, 100).Value = DBNull.Value;
                    cmd.Parameters.Add("@SPECIALITY_CODE_SYSTEM_NAME", SqlDbType.VarChar, 100).Value = DBNull.Value;
                    cmd.Parameters.Add("@SPECIALITY_DISPLAY_NAME", SqlDbType.VarChar, 250).Value = DBNull.Value;
                }
                if (obj.AdmittingDiagnosis != null)
                    cmd.Parameters.Add("@DIAGNOSIS", SqlDbType.VarChar).Value = obj.AdmittingDiagnosis;
                else
                    cmd.Parameters.Add("@DIAGNOSIS", SqlDbType.VarChar).Value = DBNull.Value;
                cmd.Parameters.Add("@SURGERY", SqlDbType.Bit).Value = (obj.Surgery == null || obj.Surgery.ToUpper().Equals("N") || obj.Surgery.ToUpper().Equals("NO")) ? 0 : 1;
                if (obj.LengthOfStayExpected.HasValue)
                    cmd.Parameters.Add("@LENGTH_OF_STAY_EXPECTED", SqlDbType.Int).Value = obj.LengthOfStayExpected;
                else
                    cmd.Parameters.Add("@LENGTH_OF_STAY_EXPECTED", SqlDbType.Int).Value = DBNull.Value;
                if (medicalDivision != null)
                {
                    cmd.Parameters.Add("@VISTA_DIVISION_CODE", SqlDbType.VarChar, 100).Value = medicalDivision.code;
                    cmd.Parameters.Add("@VISTA_DIVISION_CODE_SYSTEM", SqlDbType.VarChar, 100).Value = medicalDivision.codeSystem;
                    cmd.Parameters.Add("@VISTA_DIVISION_CODE_SYSTEM_NAME", SqlDbType.VarChar, 100).Value = medicalDivision.codeSystemName;
                    cmd.Parameters.Add("@VISTA_DIVISION_DISPLAY_NAME", SqlDbType.VarChar, 250).Value = medicalDivision.displayName;
                }
                else
                {
                    cmd.Parameters.Add("@VISTA_DIVISION_CODE", SqlDbType.VarChar, 100).Value = DBNull.Value;
                    cmd.Parameters.Add("@VISTA_DIVISION_CODE_SYSTEM", SqlDbType.VarChar, 100).Value = DBNull.Value;
                    cmd.Parameters.Add("@VISTA_DIVISION_CODE_SYSTEM_NAME", SqlDbType.VarChar, 100).Value = DBNull.Value;
                    cmd.Parameters.Add("@VISTA_DIVISION_DISPLAY_NAME", SqlDbType.VarChar, 250).Value = DBNull.Value;
                }
                cmd.ExecuteNonQuery();
                Utils.SaveVistaIntegrationLog(obj.IEN, vistaSite.Name,DC.VistaFiles.ScheduledAdmission);
                retry = 3;
            }
            catch (SqlException ex)
            {
                if (ex.Number == 1209) //Deadlock
                {
                    if (retry == 2)
                    {
                        Tracer.TraceException(ex);
                        throw ex;
                    }
                    else
                    {
                        retry++;
                        GlobalConnections.BmsConnection.Close();
                    }
                }
                else
                {
                    retry = 3;
                    Tracer.TraceException(ex);
                    throw ex;

                }
            }
            catch (Exception ex)
            {
                retry = 3;
                Tracer.TraceException(ex);
                throw ex;
            }
          }
            
        }

        public void InsertPatientAppointment(PatientAppointment obj, DC.VistaIntegrationLog vistaIntegrationLog)
        {
            int retry = 0;
            while (retry < 3)
            {
                SqlCommand cmd = new SqlCommand("usp_Insert_Discharge_Intent", GlobalConnections.BmsConnection);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.CommandTimeout = GlobalConnections.BmsConnection.ConnectionTimeout;
                try
                {
                    II patientId = GetPatientId(obj.Patient);
                    if (patientId == null) return;
                    string wardUid = Utils.GetWardFromAdmission(patientId.extension, vistaSite.Id, obj.AppointmentDateTime);
                    FC.HospitalLocation hospitalLocation = GetHospitalLocation(obj.HospitalLocationId);

                    SqlParameter idParam = cmd.Parameters.Add("@ID", SqlDbType.Int);
                    idParam.Direction = ParameterDirection.Output;
                    cmd.Parameters.Add("@DOMAIN_ID", SqlDbType.VarChar, 50).Value = Utils.DomainId;
                    cmd.Parameters.Add("@PATIENT_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(patientId.extension);
                    cmd.Parameters.Add("@DATE_ENTERED", SqlDbType.DateTime).Value = (obj.DateAppointmentMade.HasValue) ? obj.DateAppointmentMade.Value : DateTime.UtcNow;
                    cmd.Parameters.Add("@IS_ACTIVE", SqlDbType.Bit).Value = (string.IsNullOrEmpty(obj.CurrentStatus) ||
                                                                                (obj.CurrentStatus.Equals("CANCELLED", StringComparison.InvariantCultureIgnoreCase)
                                                                                || obj.CurrentStatus.Equals("DISCONTINUED", StringComparison.InvariantCultureIgnoreCase)
                                                                                || obj.CurrentStatus.Equals("COMPLETE", StringComparison.InvariantCultureIgnoreCase))) ? false : true;
                    cmd.Parameters.Add("@APPOINTMENT_DATE", SqlDbType.DateTime).Value = obj.AppointmentDateTime;
                    cmd.Parameters.Add("@VISTA_SITE_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(vistaSite.Id);
                    if (hospitalLocation != null)
                        cmd.Parameters.Add("@HOSPITAL_LOCATION_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(hospitalLocation.Id.extension);
                    else
                        cmd.Parameters.Add("@HOSPITAL_LOCATION_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;

                    if (!string.IsNullOrEmpty(obj.Status))
                        cmd.Parameters.Add("@STATUS", SqlDbType.VarChar).Value = obj.Status;
                    else
                        cmd.Parameters.Add("@STATUS", SqlDbType.VarChar).Value = DBNull.Value;
                    if (!string.IsNullOrEmpty(wardUid) && !wardUid.Equals(Guid.Empty.ToString()))
                        cmd.Parameters.Add("@WARD_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(wardUid);
                    else
                        cmd.Parameters.Add("@WARD_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;

                    cmd.ExecuteNonQuery();
                    Utils.SaveVistaIntegrationLog(vistaIntegrationLog.Ien, vistaSite.Name, vistaIntegrationLog.File);
                    retry = 3;
                }
                catch (SqlException ex)
                {
                    if (ex.Number == 1209) //Deadlock
                    {
                        if (retry == 2)
                        {
                            Tracer.TraceException(ex);
                            throw ex;
                        }
                        else
                        {
                            retry++;
                            GlobalConnections.BmsConnection.Close();
                        }
                    }
                    else
                    {
                        retry = 3;
                        Tracer.TraceException(ex);
                        throw ex;

                    }
                }
                catch (Exception ex)
                {
                    retry = 3;
                    Tracer.TraceException(ex);
                    throw ex;
                }
            }
          
        }

        public void InsertAdmissionEvent(PatientMovement obj)
        {
            int retry = 0;

            while (retry < 3)
            {
                
                SqlCommand cmd = new SqlCommand("usp_Insert_Admission_Event", GlobalConnections.BmsConnection);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.CommandTimeout = GlobalConnections.BmsConnection.ConnectionTimeout;

                try
                {
                    II patientId = GetPatientId(obj.Patient);
                    if (patientId == null) return;
                    FC.Ward ward = Utils.GetWardByIen(obj.WardLocationId, vistaSite.Id);
                    FC.Bed bed = (ward != null) ? Utils.GetBedByIen(obj.RoomBedId, ward.Id.extension) : null;
                    II enteredById = GetPersonId(obj.EnteredBy);
                    CD typeOfmovement = GetCDByIen(obj.TypeOfMovementId, FC.Util.Vocabulary.TypeOfMovement.ToString());

                    SqlParameter idParam = cmd.Parameters.Add("@ID", SqlDbType.Int);
                    idParam.Direction = ParameterDirection.Output;
                    cmd.Parameters.Add("@DOMAIN_ID", SqlDbType.VarChar, 50).Value = Utils.DomainId;
                    cmd.Parameters.Add("@PATIENT_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(patientId.extension);
                    if (!string.IsNullOrEmpty(obj.IEN))
                        cmd.Parameters.Add("@IEN", SqlDbType.VarChar, 50).Value = obj.IEN;
                    else
                        cmd.Parameters.Add("@IEN", SqlDbType.VarChar, 50).Value = DBNull.Value;
                    if (obj.EnteredOnDateTime.HasValue)
                        cmd.Parameters.Add("@ENTERED_DATE", SqlDbType.DateTime).Value = obj.EnteredOnDateTime.Value;
                    else
                        cmd.Parameters.Add("@ENTERED_DATE", SqlDbType.DateTime).Value = Utils.MinSqlDate;
                    if (bed != null)
                        cmd.Parameters.Add("@BED_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(bed.Id.extension);
                    else
                        cmd.Parameters.Add("@BED_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;
                    if (ward != null)
                        cmd.Parameters.Add("@WARD_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(ward.Id.extension);
                    else
                        cmd.Parameters.Add("@WARD_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;
                    cmd.Parameters.Add("@VISTA_SITE_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(vistaSite.Id);
                    cmd.Parameters.Add("@ATND_NURSE_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;
                    if (obj.DateTime != null)
                        cmd.Parameters.Add("@ADMISSION_DATE", SqlDbType.DateTime).Value = obj.DateTime;
                    else
                        cmd.Parameters.Add("@ADMISSION_DATE", SqlDbType.DateTime).Value = DBNull.Value;
                    if (enteredById != null)
                        cmd.Parameters.Add("@ENTERED_BY_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(enteredById.extension);
                    else
                        cmd.Parameters.Add("@ENTERED_BY_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;
                    cmd.Parameters.Add("@HAS_DISCHARGE", SqlDbType.Bit).Value = false;
                    if (typeOfmovement != null)
                    {
                        cmd.Parameters.Add("@TYPE_OF_MOVEMENT_CODE", SqlDbType.VarChar, 100).Value = typeOfmovement.code;
                        cmd.Parameters.Add("@TYPE_OF_MOVEMENT_CODE_SYSTEM", SqlDbType.VarChar, 100).Value = typeOfmovement.codeSystem;
                        cmd.Parameters.Add("@TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME", SqlDbType.VarChar, 100).Value = typeOfmovement.codeSystemName;
                        cmd.Parameters.Add("@TYPE_OF_MOVEMENT_DISPLAY_NAME", SqlDbType.VarChar, 250).Value = typeOfmovement.displayName;
                    }
                    else
                    {
                        cmd.Parameters.Add("@TYPE_OF_MOVEMENT_CODE", SqlDbType.VarChar, 100).Value = DBNull.Value;
                        cmd.Parameters.Add("@TYPE_OF_MOVEMENT_CODE_SYSTEM", SqlDbType.VarChar, 100).Value = DBNull.Value;
                        cmd.Parameters.Add("@TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME", SqlDbType.VarChar, 100).Value = DBNull.Value;
                        cmd.Parameters.Add("@TYPE_OF_MOVEMENT_DISPLAY_NAME", SqlDbType.VarChar, 250).Value = DBNull.Value;
                    }
                    cmd.ExecuteNonQuery();
                    Utils.SaveVistaIntegrationLog(obj.IEN, vistaSite.Name, DC.VistaFiles.PatientMovement);
                    retry = 3;
                }
                catch (SqlException ex)
                {
                    if (ex.Number == 1209) //Deadlock
                    {
                        if (retry == 2)
                        {
                            Tracer.TraceException(ex);
                            throw ex;
                        }
                        else
                        {
                            retry++;
                            GlobalConnections.BmsConnection.Close();
                        }
                    }
                    else
                    {
                        retry = 3;
                        Tracer.TraceException(ex);
                        throw ex;

                    }
                }
                catch (Exception ex)
                {
                    retry = 3;
                    Tracer.TraceException(ex);
                    throw ex;
                }
            }
           
        }

        public void InsertTransferEvent(PatientMovement obj, string oldBedUid, string oldWardUid)
        {
            int retry = 0;
            while (retry < 3)
            {
            SqlCommand cmd = new SqlCommand("usp_Insert_Movement_Event", GlobalConnections.BmsConnection);
            cmd.CommandType = CommandType.StoredProcedure;
            cmd.CommandTimeout = GlobalConnections.BmsConnection.ConnectionTimeout;

            try
            {
                II patientId = GetPatientId(obj.Patient);
                if (patientId == null) return;
                FC.Ward ward = Utils.GetWardByIen(obj.WardLocationId, vistaSite.Id);
                FC.Bed bed = (ward != null) ? Utils.GetBedByIen(obj.RoomBedId, ward.Id.extension) : null;                
                II enteredById = GetPersonId(obj.EnteredBy);
                CD typeOfmovement = GetCDByIen(obj.TypeOfMovementId, FC.Util.Vocabulary.TypeOfMovement.ToString());

                SqlParameter idParam = cmd.Parameters.Add("@ID", SqlDbType.Int);
                idParam.Direction = ParameterDirection.Output;
                cmd.Parameters.Add("@DOMAIN_ID", SqlDbType.VarChar, 50).Value = Utils.DomainId;
                cmd.Parameters.Add("@PATIENT_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(patientId.extension);
                if (!string.IsNullOrEmpty(obj.IEN))
                    cmd.Parameters.Add("@IEN", SqlDbType.VarChar, 50).Value = obj.IEN;
                else
                    cmd.Parameters.Add("@IEN", SqlDbType.VarChar, 50).Value = DBNull.Value;
                if (obj.EnteredOnDateTime.HasValue)
                    cmd.Parameters.Add("@ENTERED_DATE", SqlDbType.DateTime).Value = obj.EnteredOnDateTime.Value;
                else
                    cmd.Parameters.Add("@ENTERED_DATE", SqlDbType.DateTime).Value = Utils.MinSqlDate;
                if (ward != null)
                    cmd.Parameters.Add("@WARD_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(ward.Id.extension);
                else
                    cmd.Parameters.Add("@WARD_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;
                if (bed != null)
                    cmd.Parameters.Add("@BED_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(bed.Id.extension);
                else
                    cmd.Parameters.Add("@BED_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;
                if (!string.IsNullOrEmpty(oldWardUid) && !oldWardUid.Equals(Guid.Empty.ToString()))
                    cmd.Parameters.Add("@OLD_WARD_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(oldWardUid);
                else
                    cmd.Parameters.Add("@OLD_WARD_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;
                if (!string.IsNullOrEmpty(oldBedUid) && !oldBedUid.Equals(Guid.Empty.ToString()))
                    cmd.Parameters.Add("@OLD_BED_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(oldBedUid);
                else
                    cmd.Parameters.Add("@OLD_BED_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;                
                cmd.Parameters.Add("@VISTA_SITE_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(vistaSite.Id);
                if (typeOfmovement != null)
                {
                    cmd.Parameters.Add("@TYPE_OF_MOVEMENT_CODE", SqlDbType.VarChar, 100).Value = typeOfmovement.code;
                    cmd.Parameters.Add("@TYPE_OF_MOVEMENT_CODE_SYSTEM", SqlDbType.VarChar, 100).Value = typeOfmovement.codeSystem;
                    cmd.Parameters.Add("@TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME", SqlDbType.VarChar, 100).Value = typeOfmovement.codeSystemName;
                    cmd.Parameters.Add("@TYPE_OF_MOVEMENT_DISPLAY_NAME", SqlDbType.VarChar, 250).Value = typeOfmovement.displayName;
                }
                else
                {
                    cmd.Parameters.Add("@TYPE_OF_MOVEMENT_CODE", SqlDbType.VarChar, 100).Value = DBNull.Value;
                    cmd.Parameters.Add("@TYPE_OF_MOVEMENT_CODE_SYSTEM", SqlDbType.VarChar, 100).Value = DBNull.Value;
                    cmd.Parameters.Add("@TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME", SqlDbType.VarChar, 100).Value = DBNull.Value;
                    cmd.Parameters.Add("@TYPE_OF_MOVEMENT_DISPLAY_NAME", SqlDbType.VarChar, 250).Value = DBNull.Value;
                }
                if (obj.DateTime != null)
                    cmd.Parameters.Add("@MOVEMENT_DATE", SqlDbType.DateTime).Value = obj.DateTime;
                else
                    cmd.Parameters.Add("@MOVEMENT_DATE", SqlDbType.DateTime).Value = DBNull.Value;
                if (enteredById != null)
                    cmd.Parameters.Add("@ENTERED_BY_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(enteredById.extension);
                else
                    cmd.Parameters.Add("@ENTERED_BY_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;
                if (!string.IsNullOrEmpty(obj.CurrentAdmissionIen))
                    cmd.Parameters.Add("@ADMISSION_IEN", SqlDbType.NVarChar, 20).Value = obj.CurrentAdmissionIen;
                else
                    cmd.Parameters.Add("@ADMISSION_IEN", SqlDbType.NVarChar, 20).Value = DBNull.Value;
                cmd.ExecuteNonQuery();

//                if (!string.IsNullOrEmpty(obj.CurrentAdmissionIen))
//                {
//                    string wrd = (ward != null && ward.Id != null) ? "'" + ward.Id.extension + "'" : "NULL";
//                    string bd = (bed != null && bed.Id != null) ? "'" + bed.Id.extension + "'" : "NULL";
//                    //update admission event
//                    cmd = GlobalConnections.BmsConnection.CreateCommand();
//                    cmd.CommandText = string.Format(@"UPDATE ADMISSION_EVN 
//                                                    SET WARD_UID = {0},
//	                                                    BED_UID = {1}
//                                                    WHERE IEN = '{2}' AND VISTA_SITE_UID = '{3}' AND PATIENT_UID = '{4}'", wrd, bd, obj.CurrentAdmissionIen, vistaSite.Id, patientId.extension);
//                    cmd.CommandType = CommandType.Text;
//                    cmd.ExecuteNonQuery();
//                }

                Utils.SaveVistaIntegrationLog(obj.IEN, vistaSite.Name, DC.VistaFiles.PatientMovement); ;
                retry = 3;
            }
            catch (SqlException ex)
            {
                if (ex.Number == 1209) //Deadlock
                {
                    if (retry == 2)
                    {
                        Tracer.TraceException(ex);
                        throw ex;
                    }
                    else
                    {
                        retry++;
                        GlobalConnections.BmsConnection.Close();
                    }
                }
                else
                {
                    retry = 3;
                    Tracer.TraceException(ex);
                    throw ex;

                }
            }
            catch (Exception ex)
            {
                retry = 3;
                Tracer.TraceException(ex);
                throw ex;
            }
          }
            
        }

        public void InsertDischargeEvent(PatientMovement obj)
        {
            int retry = 0;
            while (retry < 3)
            {
                //SqlConnection connection = new SqlConnection(ConfigurationManager.ConnectionStrings["BMSDBConnString"].ConnectionString);
                SqlCommand cmd = new SqlCommand("usp_Insert_Discharge_Event", GlobalConnections.BmsConnection);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.CommandTimeout = GlobalConnections.BmsConnection.ConnectionTimeout;

                try
                {
                    II patientId = GetPatientId(obj.Patient);
                    if (patientId == null) return;
                    II enteredById = GetPersonId(obj.EnteredBy);
                    CD typeOfmovement = GetCDByIen(obj.TypeOfMovementId, FC.Util.Vocabulary.TypeOfMovement.ToString());

                    SqlParameter idParam = cmd.Parameters.Add("@ID", SqlDbType.Int);
                    idParam.Direction = ParameterDirection.Output;
                    cmd.Parameters.Add("@DOMAIN_ID", SqlDbType.VarChar, 50).Value = Utils.DomainId;
                    cmd.Parameters.Add("@PATIENT_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(patientId.extension);
                    if (!string.IsNullOrEmpty(obj.IEN))
                        cmd.Parameters.Add("@IEN", SqlDbType.VarChar, 50).Value = obj.IEN;
                    else
                        cmd.Parameters.Add("@IEN", SqlDbType.VarChar, 50).Value = DBNull.Value;
                    if (obj.EnteredOnDateTime.HasValue)
                        cmd.Parameters.Add("@ENTERED_DATE", SqlDbType.DateTime).Value = obj.EnteredOnDateTime.Value;
                    else
                        cmd.Parameters.Add("@ENTERED_DATE", SqlDbType.DateTime).Value = Utils.MinSqlDate;
                    if (!string.IsNullOrEmpty(obj.WardLocationId) && !obj.WardLocationId.Equals(Guid.Empty.ToString()))
                        cmd.Parameters.Add("@WARD_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(obj.WardLocationId);
                    else
                        cmd.Parameters.Add("@WARD_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;
                    if (!string.IsNullOrEmpty(obj.RoomBedId) && !obj.RoomBedId.Equals(Guid.Empty.ToString()))
                        cmd.Parameters.Add("@BED_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(obj.RoomBedId);
                    else
                        cmd.Parameters.Add("@BED_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;
                    cmd.Parameters.Add("@VISTA_SITE_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(vistaSite.Id);
                    if (obj.DateTime != null)
                        cmd.Parameters.Add("@DISCHARGED_DATE", SqlDbType.DateTime).Value = obj.DateTime;
                    else
                        cmd.Parameters.Add("@DISCHARGED_DATE", SqlDbType.DateTime).Value = DBNull.Value;
                    if (typeOfmovement != null)
                    {
                        cmd.Parameters.Add("@TYPE_OF_MOVEMENT_CODE", SqlDbType.VarChar, 100).Value = typeOfmovement.code;
                        cmd.Parameters.Add("@TYPE_OF_MOVEMENT_CODE_SYSTEM", SqlDbType.VarChar, 100).Value = typeOfmovement.codeSystem;
                        cmd.Parameters.Add("@TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME", SqlDbType.VarChar, 100).Value = typeOfmovement.codeSystemName;
                        cmd.Parameters.Add("@TYPE_OF_MOVEMENT_DISPLAY_NAME", SqlDbType.VarChar, 250).Value = typeOfmovement.displayName;
                    }
                    else
                    {
                        cmd.Parameters.Add("@TYPE_OF_MOVEMENT_CODE", SqlDbType.VarChar, 100).Value = DBNull.Value;
                        cmd.Parameters.Add("@TYPE_OF_MOVEMENT_CODE_SYSTEM", SqlDbType.VarChar, 100).Value = DBNull.Value;
                        cmd.Parameters.Add("@TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME", SqlDbType.VarChar, 100).Value = DBNull.Value;
                        cmd.Parameters.Add("@TYPE_OF_MOVEMENT_DISPLAY_NAME", SqlDbType.VarChar, 250).Value = DBNull.Value;
                    }
                    if (enteredById != null)
                        cmd.Parameters.Add("@ENTERED_BY_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(enteredById.extension);
                    else
                        cmd.Parameters.Add("@ENTERED_BY_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;
                    if (!string.IsNullOrEmpty(obj.CurrentAdmissionIen))
                        cmd.Parameters.Add("@ADMISSION_IEN", SqlDbType.NVarChar, 20).Value = obj.CurrentAdmissionIen;
                    else
                        cmd.Parameters.Add("@ADMISSION_IEN", SqlDbType.NVarChar, 20).Value = DBNull.Value;
                    cmd.ExecuteNonQuery();

//                    if (!string.IsNullOrEmpty(obj.CurrentAdmissionIen))
//                    {
//                        //update admission event
//                        cmd = GlobalConnections.BmsConnection.CreateCommand();
//                        cmd.CommandText = string.Format(@"UPDATE ADMISSION_EVN 
//                                                    SET HAS_DISCHARGE = 1
//                                                    WHERE IEN = '{0}' AND VISTA_SITE_UID = '{1}' AND PATIENT_UID = '{2}'", obj.CurrentAdmissionIen, vistaSite.Id, patientId.extension);
//                        cmd.CommandType = CommandType.Text;
//                        cmd.ExecuteNonQuery();
//                    }

                    Utils.SaveVistaIntegrationLog(obj.IEN, vistaSite.Name, DC.VistaFiles.PatientMovement);
                    retry = 3;
                }
                catch (SqlException ex)
                {
                    if (ex.Number == 1209) //Deadlock
                    {
                        if (retry == 2)
                        {
                            Tracer.TraceException(ex);
                            throw ex;
                        }
                        else
                        {
                            retry++;
                            GlobalConnections.BmsConnection.Close();
                        }
                    }
                    else
                    {
                        retry = 3;
                        Tracer.TraceException(ex);
                        throw ex;

                    }
                }
                catch (Exception ex)
                {
                    retry = 3;
                    Tracer.TraceException(ex);
                    throw ex;
                }
            }
           
        }

        public void InsertSpecialtyTransfer(PatientMovement obj)
        {
            int retry = 0;
            while (retry < 3)
            {
            SqlCommand cmd = new SqlCommand("usp_Insert_Specialty_Transfer", GlobalConnections.BmsConnection);
            cmd.CommandType = CommandType.StoredProcedure;
            cmd.CommandTimeout = GlobalConnections.BmsConnection.ConnectionTimeout;

            try
            {
                II patientId = GetPatientId(obj.Patient);
                if (patientId == null) return;
                II enteredById = GetPersonId(obj.EnteredBy);
                CD typeOfmovement = GetCDByIen(obj.TypeOfMovementId, FC.Util.Vocabulary.TypeOfMovement.ToString());

                SqlParameter idParam = cmd.Parameters.Add("@ID", SqlDbType.Int);
                idParam.Direction = ParameterDirection.Output;
                if (!string.IsNullOrEmpty(obj.IEN))
                    cmd.Parameters.Add("@IEN", SqlDbType.VarChar, 50).Value = obj.IEN;
                else
                    cmd.Parameters.Add("@IEN", SqlDbType.VarChar, 50).Value = DBNull.Value;                
                cmd.Parameters.Add("@PATIENT_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(patientId.extension);                
                cmd.Parameters.Add("@DOMAIN_ID", SqlDbType.VarChar, 50).Value = Utils.DomainId;                
                cmd.Parameters.Add("@VISTA_SITE_UID", SqlDbType.UniqueIdentifier).Value = Guid.Parse(vistaSite.Id);
                cmd.Parameters.Add("@DATE_TIME", SqlDbType.DateTime).Value = obj.DateTime;
                if (typeOfmovement != null)
                {
                    cmd.Parameters.Add("@TYPE_OF_MOVEMENT_CODE", SqlDbType.VarChar, 100).Value = typeOfmovement.code;
                    cmd.Parameters.Add("@TYPE_OF_MOVEMENT_CODE_SYSTEM", SqlDbType.VarChar, 100).Value = typeOfmovement.codeSystem;
                    cmd.Parameters.Add("@TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME", SqlDbType.VarChar, 100).Value = typeOfmovement.codeSystemName;
                    cmd.Parameters.Add("@TYPE_OF_MOVEMENT_DISPLAY_NAME", SqlDbType.VarChar, 250).Value = typeOfmovement.displayName;
                }
                else
                {
                    cmd.Parameters.Add("@TYPE_OF_MOVEMENT_CODE", SqlDbType.VarChar, 100).Value = DBNull.Value;
                    cmd.Parameters.Add("@TYPE_OF_MOVEMENT_CODE_SYSTEM", SqlDbType.VarChar, 100).Value = DBNull.Value;
                    cmd.Parameters.Add("@TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME", SqlDbType.VarChar, 100).Value = DBNull.Value;
                    cmd.Parameters.Add("@TYPE_OF_MOVEMENT_DISPLAY_NAME", SqlDbType.VarChar, 250).Value = DBNull.Value;
                }
                if (obj.EnteredOnDateTime.HasValue)
                    cmd.Parameters.Add("@ENTERED_DATE", SqlDbType.DateTime).Value = obj.EnteredOnDateTime.Value;
                else
                    cmd.Parameters.Add("@ENTERED_DATE", SqlDbType.DateTime).Value = Utils.MinSqlDate;
                if (enteredById != null)                                    
                    cmd.Parameters.Add("@ENTERED_BY_UID", SqlDbType.UniqueIdentifier).Value = new Guid(enteredById.extension);                
                else
                    cmd.Parameters.Add("@ENTERED_BY_UID", SqlDbType.UniqueIdentifier).Value = DBNull.Value;
                if (!string.IsNullOrEmpty(obj.CurrentAdmissionIen))
                    cmd.Parameters.Add("@ADMISSION_IEN", SqlDbType.NVarChar, 20).Value = obj.CurrentAdmissionIen;
                else
                    cmd.Parameters.Add("@ADMISSION_IEN", SqlDbType.NVarChar, 20).Value = DBNull.Value;     
                cmd.ExecuteNonQuery();
                Utils.SaveVistaIntegrationLog(obj.IEN, vistaSite.Name, DC.VistaFiles.PatientMovement);
                retry = 3;
            }
            catch (SqlException ex)
            {
                if (ex.Number == 1209) //Deadlock
                {
                    if (retry == 2)
                    {
                        Tracer.TraceException(ex);
                        throw ex;
                    }
                    else
                    {
                        retry++;
                        GlobalConnections.BmsConnection.Close();
                    }
                }
                else
                {
                    retry = 3;
                    Tracer.TraceException(ex);
                    throw ex;

                }
            }
            catch (Exception ex)
            {
                retry = 3;
                Tracer.TraceException(ex);
                throw ex;
            }
          }

        }

        public II GetPatientId(BMS.VistaIntegration.Data.Patient entity)
        {
            if (entity == null) return null;
            string ssn = Utils.GetSSN(entity.SocialSecurityNumber);
            II result = Utils.GetPatientBySsn(ssn);
            if (result == null)
            {
                PatientProcessor patientProcessor = new PatientProcessor(new BMS.VistaIntegration.FacadeContracts.VistASite() { Id = vistaSite.Id, Name = vistaSite.Name, Number = vistaSite.Number });
                PatientProcessor.InsertOrUpdateIndividualPatient(entity);
                result = Utils.GetPatientBySsn(ssn);
            }            
            if (result == null || string.IsNullOrEmpty(result.extension) || result.extension.Equals(Guid.Empty.ToString()))
                return null;
            return result;
        }

        private static II GetPersonId(NewPerson person)
        {
            if (person == null) return null;
            II result = Utils.GetPersonByIen(person.IEN, vistaSite.Id);
            if (result == null)
            {
                Dictionary<string, string> names = Utilities.SplitPersonFullName(person.Name);
                BMS.ServicesWrapper.EIS.EISFactory.InstanceWindows.CreateMedicalPerson(new FC.Person()
                {
                    Ien = person.IEN,
                    LastName = names[Constants.PERSON_LAST_NAME],
                    MiddleName = names[Constants.PERSON_MIDDLE_NAME],
                    FirstName = names[Constants.PERSON_FIRST_NAME],
                    VistaSite = new II(Utils.DomainId, vistaSite.Id)
                });
                result = Utils.GetPersonByIen(person.IEN, vistaSite.Id);
            }
            if (result == null || result == null || string.IsNullOrEmpty(result.extension) || result.extension.Equals(Guid.Empty.ToString()))
                return null;
            return result;
        }

        private FC.HospitalLocation GetHospitalLocation(string ien)
        {
            if (string.IsNullOrEmpty(ien)) return null;            
            FC.HospitalLocation result = hospitalLocations.Where(a => a.Ien == ien).FirstOrDefault();            
            if (result == null || string.IsNullOrEmpty(result.Id.extension) || result.Id.extension.Equals(Guid.Empty.ToString()))
                return null;
            return result;
        }

        private static CD GetOrderableItem(List<string> ordertableItemIens)
        {
            IList<CDWithProperties> cdpList = Utils.GetOrderableItem(ordertableItemIens, vistaSite.Name, orderableItems);
            if (cdpList == null || cdpList.Count == 0) return null;
            return new CD() { code = cdpList[0].code, codeSystem = cdpList[0].codeSystem, codeSystemName = cdpList[0].codeSystemName, displayName = cdpList[0].displayName };
        }

        private static CD GetCDByIen(string cdIen, string vocabularyDomain)
        {
            if (string.IsNullOrEmpty(cdIen))
                return null;
            List<CD> cdList = new List<CD>();
            if (vocabularyDomain.Equals(FC.Util.Vocabulary.TypeOfMovement.ToString(), StringComparison.InvariantCultureIgnoreCase))
            {                
                if (typeOfMovementList == null || typeOfMovementList.Count == 0)
                    typeOfMovementList = EVSFactory.InstanceWindows.GetCodes(new CodeFilterParameters() { MaxSelectedCodes = int.MaxValue, VocabularyDomain = vocabularyDomain }).ToList();                
                cdList = typeOfMovementList;
            }
            else if (vocabularyDomain.Equals(FC.Util.Vocabulary.VistaMedicalCenterDivision.ToString(), StringComparison.InvariantCultureIgnoreCase))
            {
                if (medicalDivisionList == null || medicalDivisionList.Count == 0)
                    medicalDivisionList = EVSFactory.InstanceWindows.GetCodes(new CodeFilterParameters() { MaxSelectedCodes = int.MaxValue, VocabularyDomain = vocabularyDomain }).ToList();                
                cdList = medicalDivisionList;
            }
            else if (vocabularyDomain.Equals(FC.Util.Vocabulary.VistaTreatingSpecialty.ToString(), StringComparison.InvariantCultureIgnoreCase))
            {
                if (specialtyList == null || specialtyList.Count == 0)
                    specialtyList = EVSFactory.InstanceWindows.GetCodes(new CodeFilterParameters() { MaxSelectedCodes = int.MaxValue, VocabularyDomain = vocabularyDomain }).ToList();                
                cdList = specialtyList;
            }
            if (cdList == null || cdList.Count == 0) return null;
            return cdList.Where(a => a.code == vistaSite.Name + "_" + cdIen).FirstOrDefault();
        }
    }
}
